/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.gui.internal.action;

import de.willuhn.jameica.gui.Action;
import de.willuhn.jameica.gui.GUI;
import de.willuhn.jameica.gui.internal.dialogs.DependencyDownloadDialog;
import de.willuhn.jameica.gui.internal.dialogs.DependencyMissingDialog;
import de.willuhn.jameica.plugin.Dependency;
import de.willuhn.jameica.plugin.Manifest;
import de.willuhn.jameica.services.RepositoryService;
import de.willuhn.jameica.system.Application;
import de.willuhn.jameica.system.OperationCanceledException;
import de.willuhn.jameica.update.PluginData;
import de.willuhn.jameica.update.Repository;
import de.willuhn.jameica.update.ResolverResult;
import de.willuhn.logging.Logger;
import de.willuhn.util.ApplicationException;
import de.willuhn.util.I18N;
import java.util.ArrayList;
import java.util.List;

public class PluginDownload
implements Action {
    private static final I18N i18n = Application.getI18n();

    @Override
    public void handleAction(Object context) throws ApplicationException {
        if (context == null) {
            throw new ApplicationException(i18n.tr("Kein Plugin angegeben"));
        }
        if (!(context instanceof PluginData)) {
            return;
        }
        final PluginData data = (PluginData)context;
        try {
            boolean haveDeps;
            if (data.isInstallable()) {
                if (!Application.getCallback().askUser(i18n.tr("Sind Sie sicher, da\u00df Sie {0} (Version {1})\nherunterladen und installieren m\u00f6chten?", new String[]{data.getName(), data.getAvailableVersion().toString()}), false)) {
                    return;
                }
                Repository repo = data.getPluginGroup().getRepository();
                repo.download(data, true);
                return;
            }
            Manifest mf = data.getManifest();
            mf.canDeploy(false);
            final RepositoryService service = (RepositoryService)Application.getBootLoader().getBootable(RepositoryService.class);
            final DelayedResult r = new DelayedResult();
            GUI.startSync(new Runnable(){

                @Override
                public void run() {
                    try {
                        r.result = service.resolve(data);
                    }
                    catch (ApplicationException ae) {
                        r.exception = ae;
                    }
                }
            });
            if (r.exception != null) {
                throw r.exception;
            }
            List<PluginData> resolved = r.result.getResolved();
            List<Dependency> missing = r.result.getMissing();
            boolean haveMissing = missing.size() > 0;
            boolean bl = haveDeps = resolved.size() > 0;
            if (!haveDeps && !haveMissing) {
                if (!Application.getCallback().askUser(i18n.tr("Sind Sie sicher, da\u00df Sie das Plugin\nherunterladen und installieren m\u00f6chten?"), false)) {
                    return;
                }
                Repository repo = data.getPluginGroup().getRepository();
                repo.download(data, true);
                return;
            }
            if (haveMissing) {
                DependencyMissingDialog d = new DependencyMissingDialog(1, missing);
                d.open();
                return;
            }
            DependencyDownloadDialog d = new DependencyDownloadDialog(1, resolved);
            d.open();
            ArrayList<PluginData> all = new ArrayList<PluginData>();
            all.addAll(resolved);
            all.add(data);
            service.downloadMulti(all.toArray(new PluginData[all.size()]));
        }
        catch (OperationCanceledException oce) {
            return;
        }
        catch (ApplicationException ae) {
            throw ae;
        }
        catch (Exception e) {
            Logger.error((String)"unable to ask user", (Throwable)e);
            throw new ApplicationException(i18n.tr("Fehler beim Download des Plugins: {0}", e.getMessage()));
        }
    }

    private class DelayedResult {
        private ResolverResult result;
        private ApplicationException exception;

        private DelayedResult() {
        }
    }
}

